<?php defined( 'ABSPATH' ) OR die( 'This script cannot be accessed directly.' );

/**
 * Type: Checkbox
 */

if ( empty( $item_values ) ) {
	return;
}

$output = '';

foreach ( $item_values as $item_value ) {
	
	$_value = $item_value['value'] ?? $item_value;

	if ( $_value == '' ) {
		continue;
	}

	// Replace comma to escaped QUOTATION MARK, cause comma is used in URL to separate different values
	$encoded_value = rawurlencode( str_replace( ',', /*U+0201A*/'\‚', $_value ) );

	$_atts = array(
		'class' => 'w-filter-item-value' . ( $btn_class ?? '' ),
		'data-value' => $_value,
		'style' => '',
	);

	if ( $show_post_count ) {
		$_atts['data-post-count'] = 0;
	}
	if ( ! empty( $item_value['depth'] ) ) {
		$_atts['class'] .= ' depth_' . $item_value['depth'];
	}

	$_atts = apply_filters( 'us_list_filter_value_html_atts', $_atts, $item_value, $item_name );

	$_label = esc_html( $item_value['label'] ?? $_value );
	$_label = apply_filters( 'us_list_filter_value_label', $_label, $item_value, $item_name );

	$input_atts = array(
		'type' => 'checkbox',
		'value' => $encoded_value,
		'name' => $item_name,
	);

	// Add color swatch values
	if ( isset( $item_value['color_swatch'] ) ) {
		$_atts['style'] .= '--swatch-bg-color:' . $item_value['color_swatch'] . ';';
		$_atts['style'] .= '--swatch-color:' . us_get_contrast_bg_color( $item_value['color_swatch'] ) . ';';
		$input_atts['title'] = $_label;
	}

	$output .= '<div' . us_implode_atts( $_atts ) . '>';
	$output .= '<label>';
	$output .= '<input' . us_implode_atts( $input_atts ) . '>';
	$output .= '<span class="w-filter-item-value-label">' . $_label . '</span>';

	if ( $show_post_count ) {
		$output .= '<span class="w-filter-item-value-amount">0</span>'; // set via JS
	}

	$output .= '</label>';
	$output .= '</div>'; // w-filter-item-value
}

echo $output;
